/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.animation;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.AnimationData;
import de.keksuccino.fancymenu.menu.animation.AnimationHandlerEvents;
import de.keksuccino.fancymenu.menu.animation.AnimationLoadingScreen;
import de.keksuccino.fancymenu.menu.animation.ResourcePackAnimationRenderer;
import de.keksuccino.fancymenu.menu.animation.exceptions.AnimationNotFoundException;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.rendering.animation.ExternalGifAnimationRenderer;
import de.keksuccino.konkrete.rendering.animation.ExternalTextureAnimationRenderer;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;

public class AnimationHandler {
    private static Map<String, AnimationData> animations = new HashMap<String, AnimationData>();
    private static List<String> custom = new ArrayList<String>();
    protected static boolean ready = false;
    protected static boolean containsAnimationsWithOldFormat = false;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new AnimationHandlerEvents());
    }

    public static void registerAnimation(IAnimationRenderer animation, String name, AnimationData.Type type) {
        if (!animations.containsKey(name)) {
            animations.put(name, new AnimationData(animation, name, type));
            if (type == AnimationData.Type.EXTERNAL) {
                custom.add(name);
            }
        } else {
            System.out.println("######################################");
            System.out.println("[FM AnimationHandler] Animation name '" + name + "' already used!");
            System.out.println("######################################");
        }
    }

    public static void unregisterAnimation(IAnimationRenderer animation) {
        AnimationData d = null;
        for (AnimationData a : animations.values()) {
            if (a.animation != animation) continue;
            d = a;
            break;
        }
        if (d != null) {
            AnimationHandler.unregisterAnimation(d.name);
        }
    }

    public static void unregisterAnimation(String name) {
        if (AnimationHandler.animationExists(name)) {
            animations.remove(name);
            if (custom.contains(name)) {
                custom.remove(name);
            }
        }
    }

    public static void loadCustomAnimations() {
        File f = FancyMenu.getAnimationPath();
        if (!f.exists() || !f.isDirectory()) {
            return;
        }
        ready = false;
        containsAnimationsWithOldFormat = false;
        AnimationHandler.clearCustomAnimations();
        for (File a : f.listFiles()) {
            File audio2;
            File audio1;
            PropertiesSet props;
            String name = null;
            String mainAudio = null;
            String introAudio = null;
            int fps = 0;
            boolean loop = true;
            int width = 0;
            int height = 0;
            int x = 0;
            int y = 0;
            boolean replayIntro = false;
            ArrayList<String> frameNamesMain = new ArrayList<String>();
            ArrayList<String> frameNamesIntro = new ArrayList<String>();
            String resourceNamespace = null;
            boolean isNewFormat = false;
            if (!a.isDirectory()) continue;
            File p = new File(a.getAbsolutePath() + "/properties.txt");
            if (!p.exists()) {
                p = new File(a.getAbsolutePath() + "/animation.properties");
                isNewFormat = true;
            }
            if (!p.exists()) continue;
            if (isNewFormat) {
                List mainFrameSecs;
                String replayString;
                String loopString;
                PropertiesSection m;
                List metas;
                props = PropertiesSerializer.getProperties((String)p.getPath());
                if (props == null || (metas = props.getPropertiesOfType("animation-meta")).isEmpty() || (name = (m = (PropertiesSection)metas.get(0)).getEntryValue("name")) == null) continue;
                String fpsString = m.getEntryValue("fps");
                if (fpsString != null && MathUtils.isInteger((String)fpsString)) {
                    fps = Integer.parseInt(fpsString);
                }
                if ((loopString = m.getEntryValue("loop")) != null && loopString.equalsIgnoreCase("false")) {
                    loop = false;
                }
                if ((replayString = m.getEntryValue("replayintro")) != null && replayString.equalsIgnoreCase("true")) {
                    replayIntro = true;
                }
                if ((resourceNamespace = m.getEntryValue("namespace")) == null || (mainFrameSecs = props.getPropertiesOfType("frames-main")).isEmpty()) continue;
                PropertiesSection mainFrames = (PropertiesSection)mainFrameSecs.get(0);
                Map mainFramesMap = mainFrames.getEntries();
                ArrayList mainFrameKeys = new ArrayList();
                for (Map.Entry me : mainFramesMap.entrySet()) {
                    String frameNumber;
                    if (!((String)me.getKey()).startsWith("frame_") || !MathUtils.isInteger((String)(frameNumber = ((String)me.getKey()).split("[_]", 2)[1]))) continue;
                    mainFrameKeys.add(me.getKey());
                }
                Collections.sort(mainFrameKeys, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        int i2;
                        String n1 = o1.split("[_]", 2)[1];
                        String n2 = o2.split("[_]", 2)[1];
                        int i1 = Integer.parseInt(n1);
                        if (i1 > (i2 = Integer.parseInt(n2))) {
                            return 1;
                        }
                        if (i1 < i2) {
                            return -1;
                        }
                        return 0;
                    }
                });
                for (String s : mainFrameKeys) {
                    frameNamesMain.add("frames_main/" + (String)mainFramesMap.get(s));
                }
                List introFrameSecs = props.getPropertiesOfType("frames-intro");
                if (!introFrameSecs.isEmpty()) {
                    PropertiesSection introFrames = (PropertiesSection)introFrameSecs.get(0);
                    Map introFramesMap = introFrames.getEntries();
                    ArrayList introFrameKeys = new ArrayList();
                    for (Map.Entry me : introFramesMap.entrySet()) {
                        String frameNumber;
                        if (!((String)me.getKey()).startsWith("frame_") || !MathUtils.isInteger((String)(frameNumber = ((String)me.getKey()).split("[_]", 2)[1]))) continue;
                        introFrameKeys.add(me.getKey());
                    }
                    Collections.sort(introFrameKeys, new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            int i2;
                            String n1 = o1.split("[_]", 2)[1];
                            String n2 = o2.split("[_]", 2)[1];
                            int i1 = Integer.parseInt(n1);
                            if (i1 > (i2 = Integer.parseInt(n2))) {
                                return 1;
                            }
                            if (i1 < i2) {
                                return -1;
                            }
                            return 0;
                        }
                    });
                    for (String s : introFrameKeys) {
                        frameNamesIntro.add("frames_intro/" + (String)introFramesMap.get(s));
                    }
                }
            } else {
                String s;
                props = AnimationHandler.parseProperties(p);
                if (props.isEmpty()) continue;
                if (props.containsKey("name") && (s = (String)props.get("name")) != null && !s.equals("")) {
                    name = s;
                }
                if (props.containsKey("fps") && (s = (String)props.get("fps")) != null && !s.equals("") && MathUtils.isInteger((String)s)) {
                    fps = Integer.parseInt(s);
                }
                if (props.containsKey("loop") && (s = (String)props.get("loop")) != null && !s.equals("") && s.equalsIgnoreCase("false")) {
                    loop = false;
                }
                if (props.containsKey("width") && (s = (String)props.get("width")) != null && !s.equals("") && MathUtils.isInteger((String)s)) {
                    width = Integer.parseInt(s);
                }
                if (props.containsKey("height") && (s = (String)props.get("height")) != null && !s.equals("") && MathUtils.isInteger((String)s)) {
                    height = Integer.parseInt(s);
                }
                if (props.containsKey("x") && (s = (String)props.get("x")) != null && !s.equals("") && MathUtils.isInteger((String)s)) {
                    x = Integer.parseInt(s);
                }
                if (props.containsKey("y") && (s = (String)props.get("y")) != null && !s.equals("") && MathUtils.isInteger((String)s)) {
                    y = Integer.parseInt(s);
                }
                if (props.containsKey("replayintro") && (s = (String)props.get("replayintro")) != null && s.equalsIgnoreCase("true")) {
                    replayIntro = true;
                }
            }
            if ((audio1 = new File(a.getAbsolutePath() + "/audio/mainaudio.wav")).exists()) {
                mainAudio = audio1.getPath();
            }
            if ((audio2 = new File(a.getAbsolutePath() + "/audio/introaudio.wav")).exists()) {
                introAudio = audio2.getPath();
            }
            if (name == null) continue;
            File gifIntro = new File(a.getPath() + "/intro.gif");
            File gifAni = new File(a.getPath() + "/animation.gif");
            ResourcePackAnimationRenderer in = null;
            ResourcePackAnimationRenderer an = null;
            if (isNewFormat) {
                if (!frameNamesIntro.isEmpty() && !frameNamesMain.isEmpty()) {
                    in = new ResourcePackAnimationRenderer(resourceNamespace, frameNamesIntro, fps, loop, 0, 0, 100, 100);
                    an = new ResourcePackAnimationRenderer(resourceNamespace, frameNamesMain, fps, loop, 0, 0, 100, 100);
                } else if (!frameNamesMain.isEmpty()) {
                    an = new ResourcePackAnimationRenderer(resourceNamespace, frameNamesMain, fps, loop, 0, 0, 100, 100);
                }
            } else if (gifAni.exists()) {
                if (gifIntro.exists() && gifAni.exists()) {
                    in = new ExternalGifAnimationRenderer(gifIntro.getPath(), loop, x, y, width, height);
                    an = new ExternalGifAnimationRenderer(gifAni.getPath(), loop, x, y, width, height);
                    containsAnimationsWithOldFormat = true;
                } else if (gifAni.exists()) {
                    an = new ExternalGifAnimationRenderer(gifAni.getPath(), loop, x, y, width, height);
                    containsAnimationsWithOldFormat = true;
                }
            } else {
                String intro = AnimationHandler.getIntroPath(a.getPath());
                String ani = AnimationHandler.getAnimationPath(a.getPath());
                if (intro != null && ani != null) {
                    in = new ExternalTextureAnimationRenderer(intro, fps, loop, x, y, width, height);
                    an = new ExternalTextureAnimationRenderer(ani, fps, loop, x, y, width, height);
                    containsAnimationsWithOldFormat = true;
                } else if (ani != null) {
                    an = new ExternalTextureAnimationRenderer(ani, fps, loop, x, y, width, height);
                    containsAnimationsWithOldFormat = true;
                }
            }
            try {
                AdvancedAnimation ani;
                if (in != null && an != null) {
                    ani = new AdvancedAnimation(in, an, introAudio, mainAudio, replayIntro);
                    AnimationHandler.registerAnimation(ani, name, AnimationData.Type.EXTERNAL);
                    if (isNewFormat) {
                        ani.prepareAnimation();
                    }
                    System.out.println("[FM AnimationHandler] Custom animation found and registered: " + name + "");
                    continue;
                }
                if (an != null) {
                    ani = new AdvancedAnimation(null, an, introAudio, mainAudio, false);
                    AnimationHandler.registerAnimation(ani, name, AnimationData.Type.EXTERNAL);
                    if (isNewFormat) {
                        ani.prepareAnimation();
                    }
                    System.out.println("[FM AnimationHandler] Custom animation found and registered: " + name + "");
                    continue;
                }
                System.out.println("[FM AnimationHandler] ### ERROR: This is not a valid animation: " + name);
            }
            catch (AnimationNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (!containsAnimationsWithOldFormat) {
            ready = true;
        }
    }

    public static List<String> getCustomAnimationNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(custom);
        return l;
    }

    private static String getIntroPath(String path) {
        File f = new File(path + "/intro");
        if (f.exists() && f.isDirectory()) {
            return f.getPath();
        }
        return null;
    }

    private static String getAnimationPath(String path) {
        File f = new File(path + "/animation");
        if (f.exists() && f.isDirectory()) {
            return f.getPath();
        }
        return null;
    }

    private static void clearCustomAnimations() {
        for (String s : custom) {
            if (!animations.containsKey(s)) continue;
            animations.remove(s);
        }
    }

    private static Map<String, String> parseProperties(File prop) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (prop.exists() && prop.isFile()) {
            for (String s : FileUtils.getFileLines((File)prop)) {
                if (!s.contains("=")) continue;
                String name = s.split("[=]", 2)[0].replace(" ", "");
                String value = s.split("[=]", 2)[1].replace(" ", "");
                m.put(name, value);
            }
        }
        return m;
    }

    public static void setupAnimations(GuiOpenEvent e) {
        if (!animations.isEmpty() && containsAnimationsWithOldFormat) {
            Object s = null;
            s = e.getGui() != null ? e.getGui() : new MainMenuScreen();
            AnimationLoadingScreen l = new AnimationLoadingScreen((Screen)s, AnimationHandler.getAnimations().toArray(new IAnimationRenderer[0])){

                @Override
                public void onFinished() {
                    ready = true;
                    super.onFinished();
                }
            };
            e.setGui((Screen)l);
        } else {
            ready = true;
        }
    }

    public static boolean animationExists(String name) {
        return animations.containsKey(name);
    }

    public static List<IAnimationRenderer> getAnimations() {
        ArrayList<IAnimationRenderer> renderers = new ArrayList<IAnimationRenderer>();
        for (Map.Entry<String, AnimationData> m : animations.entrySet()) {
            renderers.add(m.getValue().animation);
        }
        return renderers;
    }

    public static IAnimationRenderer getAnimation(String name) {
        if (AnimationHandler.animationExists(name)) {
            return AnimationHandler.animations.get((Object)name).animation;
        }
        return null;
    }

    public static void resetAnimations() {
        for (AnimationData d : animations.values()) {
            d.animation.resetAnimation();
        }
    }

    public static void resetAnimationSounds() {
        for (AnimationData d : animations.values()) {
            if (!(d.animation instanceof AdvancedAnimation)) continue;
            ((AdvancedAnimation)d.animation).resetAudio();
        }
    }

    public static void stopAnimationSounds() {
        for (AnimationData d : animations.values()) {
            if (!(d.animation instanceof AdvancedAnimation)) continue;
            ((AdvancedAnimation)d.animation).stopAudio();
        }
    }

    public static boolean isReady() {
        return ready;
    }
}

